"""
LetMeDoIt AI Plugin - ask Gemma

Ask Google Gemma for information

[FUNCTION_CALL]
"""


from cybertask import config
from cybertask.ollamachat import OllamaChat

def ask_gemma(function_args):
    query = function_args.get("query") # required
    config.stopSpinning()
    OllamaChat().run(query, model="gemma:7b")
    return ""

functionSignature = {
    "name": "ask_gemma",
    "description": "Ask Gemma to chat or provide information",
    "parameters": {
        "type": "object",
        "properties": {
            "query": {
                "type": "string",
                "description": "The request in detail, including any supplementary information",
            },
        },
        "required": ["query"],
    },
}

config.addFunctionCall(name="ask_gemma", signature=functionSignature, method=ask_gemma)
config.inputSuggestions.append("Ask Gemma: ")